@extends('layouts.app')

@section('title', '401 Unauthorized')

@section('content')
<div class="error-container">
    <div class="error-image">
        <svg xmlns="http://www.w3.org/2000/svg" class="feather feather-user-x" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
            <circle cx="12" cy="7" r="4" fill="rgba(255,255,255,0.1)" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></circle>
            <path d="M16 21v-2a4 4 0 0 0-8 0v2" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></path>
            <line x1="17" y1="8" x2="21" y2="12" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></line>
            <line x1="21" y1="8" x2="17" y2="12" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></line>
        </svg>
    </div>
    
    <h1 class="error-code">401</h1>
    <h2 class="error-title">Unauthorized</h2>
    
    <p class="error-message">
        You must be logged in to access this page. Please sign in with a valid account.
    </p>
    
    <div class="error-actions">
        @guest
            <a href="{{ route('login.steam') }}" class="btn btn-secondary">Sign In</a>
        @else
            <a href="{{ url()->previous() }}" class="btn btn-primary">Go Back</a>
        @endguest
    </div>
</div>
@endsection
